# SinterForge ⚒️

![Blender Version](https://img.shields.io/badge/Blender-3.0%2B-orange) ![Platform](https://img.shields.io/badge/Platform-Windows%20%7C%20Mac%20%7C%20Linux-lightgrey) ![License](https://img.shields.io/badge/License-Attribution%20Required-blue)

**Turn your smooth resin prints into premium sintered masterpieces.**

SinterForge is a Blender Add-on that procedurally generates "Fuzzy Skin," "Cast Iron," and "Corroded" textures on your 3D models. It bridges the gap between the flawless accuracy of resin printing and the tactile, professional finish of industrial SLS (Selective Laser Sintering) machines.

## 📖 The Story

It started when I bought a **Mars 5 Ultra**.

My goal was simple: print high-quality proxies for **Warhammer 40k** and **Trench Crusade**. But as I fell deeper into the 3D printing rabbit hole, I started printing functional tools for my workshop—specifically **Wago dispensers** and organizers.

The prints came out technically perfect... *too perfect*.

If you've printed with resin, you know the look: glossy, smooth, almost wet-looking plastic. It feels cheap on a tool, and it looks fake on a grimdark miniature that's supposed to be ancient, rusted armor. I found myself missing the gritty, matte, "premium" texture you get from expensive nylon SLS prints.

I realized that if I wanted that texture, I had to build it myself. **SinterForge** is the result: a tool designed to take your perfect CAD files and give them the "grit" they deserve.

## ⚠️ Hardware Requirements

**"Can my printer handle this?"**

SinterForge generates *micro-textures*. It creates actual physical geometry (bumps and pits) that can be as small as **0.01mm**.

* ✅ **Recommended (8K / 9K / 12K):** Printers like the *Mars 5 Ultra*, *Saturn 4 Ultra*, or *Phrozen Mighty 8K*. These machines have pixels small enough to capture every single grain of the texture.

* ⚠️ **Minimum (4K):** You will see the texture, but it may look softer—more like "cast metal" than "fine powder."

* ❌ **Not Recommended (2K):** Older printers likely won't resolve the noise, and it may just look like a print artifact.

## ⚙️ How It Works: The Two Modes

SinterForge isn't just a noise generator; it understands the difference between a precision tool and a rusted monster.

### 1. 🔩 Mechanical Mode (The "Wago" Mode)

* **Best for:** Functional parts, brackets, dispensers, tools.
* **The Tech:** Uses `Simple Subdivision` (Non-Destructive).
* **Why:** It keeps your hard edges sharp and your dimensions accurate. If you are printing a Wago mount, you need the rails to be straight so the connectors slide. This mode adds texture to the surface faces *without* melting the geometry or rounding off your corners.

### 2. 💀 Organic Mode (The "Grimdark" Mode)

* **Best for:** Miniatures, terrain, rocks, rusted armor, base toppers.
* **The Tech:** Uses `Voxel Remesh` (Destructive).
* **Why:** It melts the entire mesh into a single "cloud" of geometry before applying the texture. This allows for deep, pitted corrosion or natural stone textures where "perfect edges" are actually the enemy.

## 🚀 Installation

SinterForge is a **Folder-based Add-on** (this allows us to save your Presets nicely!).

1. **Download** the latest release `.zip` from this repository.
   * *Note for Source Code users:* If you clone the repo, ensure the folder is named `sinter_forge` (underscore), **NOT** `sinter-forge` (dash).

2. Zip the folder up so you have `sinter_forge.zip`.

3. Open Blender.

4. Go to **Edit > Preferences > Add-ons**.

5. Click **Install...** and select your zip file.

6. Check the box to **Enable** SinterForge.

> **Note:** In Blender 4.2+, this may appear in the "Legacy" section of your extensions list. This is normal for local tools and does not affect performance.

## 🎛️ Usage Guide

1. **Select Objects:** Click on the parts you want to texture in the 3D Viewport.

2. **Open Panel:** Press `N` to open the sidebar and click the **SinterForge** tab.

3. **Choose a Style:**
   * *Standard Grit:* The classic sandpaper/SLS look.
   * *Corrosion:* Rusted, eroded, pitted look (uses Musgrave noise).
   * *Hammered:* Dented metal look (uses Voronoi noise).

4. **Forge:** Click the big **Forge Texture** button.

5. **Export:** Select your object and **File > Export > STL**. (Blender applies the modifiers automatically during export).

### 💾 The Preset Library

Don't want to dial in settings every time?

1. Customize your sliders (Strength, Scale, Roughness).
2. Click the **+ (Plus)** button in the Library section.
3. Give it a name (e.g., "Heavy Rust").
4. It is now saved as a JSON file in your `presets/` folder and can be shared with the community!

## 🤝 Attribution & Credits

This project is open source, but it relies on the support of its sponsors to exist.

**Developed by:** Sascha aka 6runk

**Made possible by:** [**A+S GmbH**](https://aus.gmbh)

<a href="https://aus.gmbh">
  <img src="https://aus.gmbh/assets/logo.png" alt="AUS GmbH" width="200">
</a>

*Without their support, I would still be sanding my prints by hand.*

## 📄 License

This software is provided "as is." You are free to use, modify, and distribute this software for personal or commercial projects.

**Attribution Clause:**
Any forks, redistributions, or public usage of this source code **must** retain the original attribution to **Sascha aka 6runk** and the link to [**A+S GmbH**](https://aus.gmbh) in the documentation and user interface.